<?php

namespace Mtc\VehicleValuation\Config;

use App\Facades\Settings;

class EVAConfig
{
    public function enabled(): bool
    {
        return Settings::get('valuation-eva-enabled') ?? false;
    }

    public function tokenAuthHeaders(): array
    {
        return [
            'Authorization' => 'Basic ' . $this->getAuthValue(),
        ];
    }

    public function isLiveEnvironment(): bool
    {
        return Settings::get('valuation-eva-use-live') ?? false;
    }

    public function questionSetId(): ?int
    {
        return Settings::get('valuation-eva-question-set-id');
    }

    public function categoryCode(): ?string
    {
        return Settings::get('valuation-eva-question-category-code');
    }

    public function conditionValue(): ?string
    {
        return Settings::get('valuation-eva-question-overall-condition');
    }

    public function lcvUsageValue(): ?string
    {
        return Settings::get('valuation-eva-question-lcv-usage');
    }

    protected function getAuthValue(): string
    {
        return base64_encode(
            Settings::get('valuation-eva-client-id') . ':' . Settings::get('valuation-eva-client-secret')
        );
    }
}
