<?php

namespace Mtc\VehicleValuation\Config;

use App\Facades\Settings;

class HPIConfig
{
    protected static string $endpoint_live = 'https://wss.hpi.co.uk/TradeSoap/services/SupplementaryEnquiryV1/';
    protected static string $endpoint_test = 'http://pat-wss.hpi.co.uk/TradeSoap/services/SupplementaryEnquiryV1/';

    public function enabled()
    {
        return Settings::get('valuation-hpi-enabled');
    }

    public function customerCode()
    {
        return Settings::get('valuation-hpi-customer_code');
    }

    public function password()
    {
        return Settings::get('valuation-hpi-password');
    }

    public function initials()
    {
        return Settings::get('valuation-hpi-initials');
    }

    public function primaryProductCode()
    {
        return Settings::get('valuation-hpi-primary_product_code');
    }

    public function supplementaryProductCode()
    {
        return Settings::get('valuation-hpi-supplementary_product_code');
    }

    public function endpoint()
    {
        return app()->environment() === 'production'
            ? self::$endpoint_live
            : self::$endpoint_test;
    }
}
