<?php

namespace Mtc\VehicleValuation\Config;

use App\Facades\Settings;
use Illuminate\Support\Facades\Log;

class MotorCheckConfig
{
    public function enabled(): bool
    {
        return !empty($this->clientId()) && !empty($this->clientSecret());
    }

    public function clientId(): string
    {
        return config('valuation.drivers.motor-check.client_id');
    }

    public function clientSecret(): string
    {
        return config('valuation.drivers.motor-check.client_secret');
    }

    public function valuationDriver(): string
    {
        return config('valuation.drivers.motor-check.driver', 'auto-trader');
    }
    public function country(): string
    {
        return config('valuation.drivers.motor-check.country', 'GB');
    }
}
